<?php

namespace App\Http\Controllers;

use App\Models\Concepto;
use Illuminate\Http\Request;

class ConceptoController extends Controller
{
    public function index()
    {
        $conceptos = Concepto::orderBy('nombre')->get();
        return view('caja.conceptos.index', compact('conceptos'));
    }

    public function create()
    {
        return view('caja.conceptos.create');
    }

    public function store(Request $request)
{
    $request->validate([
        'nombre' => 'required|string|max:100',
        'precio' => 'required|numeric|min:0',
        'tipo_concepto' => 'nullable|string|max:20',
    ]);

    try {
        Concepto::create([
            'nombre' => $request->nombre,
            'precio' => $request->precio,
            'tipo_concepto' => $request->tipo_concepto,
            'activo' => $request->activo ?? 0,
        ]);

        return response()->json(['success' => true]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Error al registrar el concepto: ' . $e->getMessage()
        ], 500);
    }
}

public function show($id)
{
    $concepto = Concepto::find($id);

    if (!$concepto) {
        return response()->json(['success' => false], 404);
    }

    return response()->json([
        'success' => true,
        'concepto' => $concepto
    ]);
}


    public function edit($id)
    {
        $concepto = Concepto::findOrFail($id);
        return view('caja.conceptos.edit', compact('concepto'));
    }

    public function update(Request $request, $id)
{
    $request->validate([
        'nombre' => 'required|string|max:100',
        'precio' => 'required|numeric|min:0',
        'tipo_concepto' => 'nullable|string|max:20',
    ]);

    $concepto = Concepto::findOrFail($id);
    $concepto->update($request->only('nombre', 'precio', 'tipo_concepto'));

    return response()->json(['success' => true]);
}

    public function destroy($id)
    {
        try {
            Concepto::destroy($id);
            return response()->json(['success' => true]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Error al eliminar.']);
        }
    }

}
