@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Requisitos @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="card-header">
                    <form id="filtro-form">
                        <div class="row align-items-end">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="dni">DNI:</label>
                                    <input type="text" name="dni" id="dni" class="form-control" 
                                        placeholder="Ingresa el DNI" maxlength="8" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <button type="button" class="btn btn-primary" onclick="buscarEstudiante()">Buscar</button>
                                    <button type="button" class="btn btn-success" onclick="generarCertificado()" id="btnGenerar" style="display: none;">Generar Certificado</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

                 <div class="card-body">
                    <div id="infoEstudiante" class="mb-3">
                        <h5 id="nombreEstudiante"></h5>
                    </div>
                    <table id="tablaResultados" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th rowspan="2">UNIDAD DIDÁCTICA</th>
                                <th rowspan="2">CRÉDITOS</th>
                                <th colspan="2">CALIFICATIVOS</th>
                                <th rowspan="2">AÑO</th>
                                <th rowspan="2">PER. ACAD.</th>
                                <th rowspan="2">SEMESTRE</th>
                            </tr>
                            <tr>
                                <th>NÚMEROS</th>
                                <th>LETRAS</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->






<!-- Modal -->






<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaInstituto").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaInstituto_wrapper .col-md-6:eq(0)');
    });
</script>


<script>
    function buscarEstudiante() {
        const dni = document.getElementById('dni').value;

        if (!dni) {
            alert("Por favor, ingresa un DNI.");
            return;
        }

        fetch("{{ route('certificado.buscar') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ dni: dni })
        })
        .then(res => res.json())
        .then(data => {
            llenarTabla(data, dni);
        })
        .catch(err => {
            console.error("Error en la búsqueda:", err);
        });
    }

    function llenarTabla(data, dni) {
        const tbody = document.querySelector('#tablaResultados tbody');
        const nombreEstudiante = document.getElementById('nombreEstudiante');
        const btnGenerar = document.getElementById('btnGenerar');

        tbody.innerHTML = '';
        btnGenerar.style.display = 'none';

        if (!data || !data.resultados || data.resultados.length === 0) {
            nombreEstudiante.textContent = 'Estudiante no encontrado.';
            tbody.innerHTML = '<tr><td colspan="7">No se encontraron resultados.</td></tr>';
            return;
        }

        nombreEstudiante.textContent = data.nombre;

        let semestreActual = '';
        data.resultados.forEach(row => {
            if (semestreActual !== row.semestre) {
                semestreActual = row.semestre;
                tbody.innerHTML += `
                    <tr class="table-secondary">
                        <td colspan="7" style="text-align: left;"><strong>PERIODO ${semestreActual}</strong></td>
                    </tr>`;
            }

            tbody.innerHTML += `
                <tr>
                    <td style="text-align: left;">${row.curso}</td>
                    <td>${row.creditos}</td>
                    <td>${row.nota_final || '-'}</td>
                    <td>${row.nota_final_letras || '-'}</td>
                    <td>${row.año}</td>
                    <td>${row.periodo}</td>
                    <td>${row.semestre}</td>
                </tr>`;
        });

        if (data.certificable) {
            btnGenerar.style.display = 'inline-block';
            btnGenerar.setAttribute('data-dni', dni);
        } else {
            btnGenerar.style.display = 'none';
            Swal.fire({
                icon: 'warning',
                title: 'No se puede emitir el certificado',
                text: data.mensaje || 'El estudiante no tiene todas las prácticas registradas.'
            });
        }
    }

    function generarCertificado() {
        const dni = document.getElementById('btnGenerar').getAttribute('data-dni');
        if (dni) {
            window.open(`/certificado/${dni}`, '_blank');
        }
    }
</script>




@endsection
