@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Estudiante @endslot
@slot('title') Estudiantes @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card shadow-sm border-0">
            <div class="card-body">

                <h4 class="text-primary mb-4">Editar Perfil</h4>

                <form id="form-perfil" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    {{-- 1. Datos Personales --}}
                    <div class="card mb-4 border-start border-4 border-primary shadow-sm">
                        <div class="card-header bg-primary text-white fw-semibold">1. Datos Personales</div>
                        <div class="card-body row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Nombres</label>
                                <input type="text" name="nombres" value="{{ old('nombres', $postulante->nombres) }}" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Apellidos</label>
                                <input type="text" name="apellidos" value="{{ old('apellidos', $postulante->apellidos) }}" class="form-control">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">DNI</label>
                                <input type="text" name="dni" value="{{ old('dni', $postulante->dni) }}" class="form-control" disabled>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Género</label>
                                <select name="genero" class="form-select">
                                    <option value="Masculino" {{ old('genero', $postulante->genero) == 'Masculino' ? 'selected' : '' }}>Masculino</option>
                                    <option value="Femenino" {{ old('genero', $postulante->genero) == 'Femenino' ? 'selected' : '' }}>Femenino</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Fecha de Nacimiento</label>
                                <input type="date" name="fecha_nacimiento" value="{{ old('fecha_nacimiento', $postulante->fecha_nacimiento) }}" class="form-control">
                            </div>
                        </div>
                    </div>

                    {{-- 2. Información de Contacto --}}
                    <div class="card mb-4 border-start border-4 border-success shadow-sm">
                        <div class="card-header bg-success text-white fw-semibold">2. Información de Contacto</div>
                        <div class="card-body row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Correo electrónico</label>
                                <input type="email" name="email" value="{{ old('email', $postulante->email) }}" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Teléfono</label>
                                <input type="text" name="telefono" value="{{ old('telefono', $postulante->telefono) }}" class="form-control">
                            </div>
                            <div class="col-12">
                                <label class="form-label">Dirección</label>
                                <input type="text" name="direccion" value="{{ old('direccion', $postulante->direccion) }}" class="form-control">
                            </div>
                        </div>
                    </div>

                    {{-- 3. Información Académica --}}
                    <div class="card mb-4 border-start border-4 border-info shadow-sm">
                        <div class="card-header bg-info text-white fw-semibold">3. Información Académica</div>
                        <div class="card-body row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Colegio</label>
                                <select name="id_colegio" class="form-select select2">
                                    @foreach($colegios as $colegio)
                                        <option value="{{ $colegio->id_colegio }}" {{ old('id_colegio', $postulante->id_colegio) == $colegio->id_colegio ? 'selected' : '' }}>
                                            {{ $colegio->nombre }}
                                        </option>
                                    @endforeach
                                </select>

                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Año de Egreso</label>
                                <input type="text" name="año_egreso" value="{{ old('año_egreso', $postulante->año_egreso) }}" class="form-control">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Lengua Materna</label>
                                <input type="text" name="lengua_materna" value="{{ old('lengua_materna', $postulante->lengua_materna) }}" class="form-control">
                            </div>
                        </div>
                    </div>

                    {{-- 4. Documentos --}}
                    <div class="card mb-4 border-start border-4 border-warning shadow-sm">
                        <div class="card-header bg-warning text-dark fw-semibold">4. Documentos</div>
                        <div class="card-body row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Certificado de Estudios</label>
                                <input type="file" name="certificado_estudios" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Partida de Nacimiento</label>
                                <input type="file" name="partida_nacimiento" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Copia de DNI</label>
                                <input type="file" name="copia_dni" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Comprobante de Pago</label>
                                <input type="file" name="comprobante_pago" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Currículum Vitae</label>
                                <input type="file" name="curriculum_archivo" class="form-control">
                            </div>

                        </div>
                    </div>

                    {{-- 5. Foto de Perfil --}}
                    <div class="card mb-4 border-start border-4 border-secondary shadow-sm">
                        <div class="card-header bg-secondary text-white fw-semibold">5. Foto de Perfil</div>
                        <div class="card-body row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Foto</label>
                                <input type="file" name="foto_postulante" class="form-control">
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary px-4">Guardar Cambios</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>


<!-- Modal de agregar -->
<!-- Modal para crear nuevo requisito -->









<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
   
</script>


<script>
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: "Seleccione un colegio",
            allowClear: true,
            width: '100%'
        });
    });
</script>

<script>
    $('#form-perfil').submit(function(e) {
        e.preventDefault();

        let formData = new FormData(this);

        $.ajax({
            url: "{{ route('estudiantes.perfil.actualizar') }}",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Éxito',
                    text: 'Perfil actualizado correctamente.'
                });
            },
            error: function(xhr) {
                let errores = xhr.responseJSON.errors;
                let mensaje = 'Ocurrieron errores:<br>';
                for (let campo in errores) {
                    mensaje += `<li>${errores[campo][0]}</li>`;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    html: `<ul>${mensaje}</ul>`
                });
            }
        });
    });
</script>





@endsection
