<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Practicas Profesionales <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <a href="<?php echo e(route('practicass.create')); ?>" 
                class="btn btn-de-primary btn-sm px-4 mt-0 mb-3">
                    <i class="fas fa-plus"></i> Agregar Nuevo Registro
                </a>

                <div class="table-responsive">
                    <table id="tablaPracticas" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>Postulante</th>
                                <th>Módulo</th>
                                <th>Empresa</th>
                                <th>Asesor</th>
                                <th>Fechas</th>
                                <th>Nota</th>
                                <th>Estado</th>
                                <th>Archivo</th>

                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $practicas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $practica): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($practica->id); ?></td>
                                <td><?php echo e($practica->postulante->nombre_completo ?? '—'); ?></td>
                                <td><?php echo e($practica->modulo->nombre ?? '—'); ?></td>
                                <td>
                                    <?php echo e($practica->empresa_nombre); ?><br>
                                    <small><?php echo e($practica->empresa_ruc); ?></small>
                                </td>
                                <td><?php echo e($practica->asesor->nombre_completo); ?></td>
                                <td>
                                    <small>
                                        Inicio: <?php echo e($practica->fecha_inicio); ?><br>
                                        Fin: <?php echo e($practica->fecha_fin); ?>

                                    </small>
                                </td>
                                <td><?php echo e($practica->nota ?? '—'); ?></td>
                                <td>
                                    <span class="badge 
                                        <?php echo e($practica->estado === 'aprobado' ? 'badge-soft-success' : 
                                        ($practica->estado === 'desaprobado' ? 'badge-soft-danger' : 'badge-soft-secondary')); ?>">
                                        <?php echo e(ucfirst($practica->estado)); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($practica->archivo_evidencia): ?>
                                        <a href="<?php echo e(asset($practica->archivo_evidencia)); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                            Ver archivo
                                        </a>
                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <!-- Ícono editar -->
                                    <a href="<?php echo e(route('practicass.edit', $practica->id)); ?>"
                                    class="text-warning me-2 btn-editar-practica"
                                    data-id="<?php echo e($practica->id); ?>"
                                    title="Editar">
                                        <i class="las la-pen text-secondary font-18"></i>
                                    </a>


                                    <!-- Ícono eliminar -->
                                    <a href="#"
                                    class="text-danger btn-eliminar-practica"
                                    data-id="<?php echo e($practica->id); ?>"
                                    title="Eliminar">
                                        <i class="las la-trash-alt text-secondary font-18"></i>
                                    </a>

                                    <!-- Formulario oculto de eliminación -->
                                    <form id="form-eliminar-<?php echo e($practica->id); ?>"
                                        action="<?php echo e(route('practicass.destroy', $practica->id)); ?>"
                                        method="POST"
                                        style="display: none;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center">No hay prácticas registradas.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<!-- Modal de edición de práctica -->
<div class="modal fade" id="modalEditarPractica" tabindex="-1" aria-labelledby="editarPracticaLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="formEditarPractica" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="editarPracticaLabel">Editar Práctica Profesional</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>

                <div class="modal-body row">
                    <!-- Asesor -->
                    <div class="col-md-6 mb-3">
                        <label for="id_asesor_edit">Asesor</label>
                        <select class="form-select" name="id_asesor" id="id_asesor_edit" required>
                            <?php $__currentLoopData = $asesores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asesor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($asesor->id); ?>"><?php echo e($asesor->nombre_completo); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Empresa -->
                    <div class="col-md-6 mb-3">
                        <label for="empresa_nombre_edit">Empresa</label>
                        <input type="text" name="empresa_nombre" id="empresa_nombre_edit" class="form-control" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="empresa_ruc_edit">RUC Empresa</label>
                        <input type="text" name="empresa_ruc" id="empresa_ruc_edit" class="form-control" required>
                    </div>

                    <!-- Fechas -->
                    <div class="col-md-6 mb-3">
                        <label for="fecha_inicio_edit">Fecha Inicio</label>
                        <input type="date" name="fecha_inicio" id="fecha_inicio_edit" class="form-control" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="fecha_fin_edit">Fecha Fin</label>
                        <input type="date" name="fecha_fin" id="fecha_fin_edit" class="form-control" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="fecha_registro_edit">Fecha Registro</label>
                        <input type="date" name="fecha_registro" id="fecha_registro_edit" class="form-control" required>
                    </div>

                    <!-- Nota -->
                    <div class="col-md-3 mb-3">
                        <label for="nota_edit">Nota</label>
                        <input type="number" name="nota" id="nota_edit" class="form-control" step="0.01" min="0" max="20">
                    </div>

                    <!-- Estado -->
                    <div class="col-md-3 mb-3">
                        <label for="estado_edit">Estado</label>
                        <select name="estado" id="estado_edit" class="form-select">
                            <option value="pendiente">Pendiente</option>
                            <option value="aprobado">Aprobado</option>
                            <option value="desaprobado">Desaprobado</option>
                        </select>
                    </div>

                    <!-- Observación -->
                    <div class="col-md-12 mb-3">
                        <label for="observacion_edit">Observación</label>
                        <textarea name="observacion" id="observacion_edit" class="form-control" rows="2"></textarea>
                    </div>

                    <!-- Archivo -->
                    <div class="col-md-12 mb-3">
                        <label for="archivo_evidencia_edit">Archivo Evidencia (PDF, DOC, IMG)</label>
                        <input type="file" name="archivo_evidencia" id="archivo_evidencia_edit" class="form-control">
                        <small id="archivoActual" class="text-muted"></small>
                    </div>

                    <!-- Hidden ID -->
                    <input type="hidden" id="practica_id_edit" name="id">
                    <input type="hidden" name="postulante_id" id="postulante_id_edit">
                    <input type="hidden" name="id_modulo" id="id_modulo_edit">

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPracticas").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPracticas_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
   document.addEventListener('DOMContentLoaded', function () {
    // Al hacer clic en editar
    document.querySelectorAll('.btn-editar-practica').forEach(btn => {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            const id = this.dataset.id;

            fetch(`/practicass/${id}/edit`)
                .then(response => response.json())
                .then(data => {
                    // Rellenar campos
                    document.getElementById('practica_id_edit').value = data.id;
                    document.getElementById('id_asesor_edit').value = data.id_asesor;
                    document.getElementById('empresa_nombre_edit').value = data.empresa_nombre;
                    document.getElementById('empresa_ruc_edit').value = data.empresa_ruc;
                    document.getElementById('fecha_inicio_edit').value = data.fecha_inicio;
                    document.getElementById('fecha_fin_edit').value = data.fecha_fin;
                    document.getElementById('fecha_registro_edit').value = data.fecha_registro;
                    document.getElementById('nota_edit').value = data.nota ?? '';
                    document.getElementById('estado_edit').value = data.estado ?? 'pendiente';
                    document.getElementById('observacion_edit').value = data.observacion ?? '';
                    document.getElementById('postulante_id_edit').value = data.postulante_id;
                    document.getElementById('id_modulo_edit').value = data.id_modulo;

                    document.getElementById('archivoActual').textContent = data.archivo_evidencia 
                        ? `Archivo actual: ${data.archivo_evidencia.split('/').pop()}` 
                        : 'No hay archivo actual';

                    // Mostrar modal
                    new bootstrap.Modal(document.getElementById('modalEditarPractica')).show();
                })
                .catch(err => {
                    Swal.fire('Error', 'No se pudo cargar la práctica.', 'error');
                });
        });
    });

    // Enviar formulario de edición
    document.getElementById('formEditarPractica').addEventListener('submit', function (e) {
        e.preventDefault();

        const id = document.getElementById('practica_id_edit').value;
        const formData = new FormData(this);

        fetch(`/practicass/${id}`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                Swal.fire('Actualizado', data.message, 'success').then(() => {
                    location.reload(); // Recarga para reflejar cambios
                });
            } else {
                Swal.fire('Error', data.message || 'Error al actualizar.', 'error');
            }
        })
        .catch(err => {
            Swal.fire('Error', 'No se pudo actualizar la práctica.', 'error');
        });
    });
});


</script>
 <script>
    // Eliminar práctica profesional con confirmación
document.querySelectorAll('.btn-eliminar-practica').forEach(btn => {
    btn.addEventListener('click', function (e) {
        e.preventDefault();
        const id = this.dataset.id;

        Swal.fire({
            title: '¿Estás seguro?',
            text: 'Esta acción no se puede deshacer.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
        }).then((result) => {
            if (result.isConfirmed) {
                fetch(`/practicass/${id}`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: new URLSearchParams({ _method: 'DELETE' })
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire('Eliminado', data.message, 'success').then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire('Error', data.message || 'No se pudo eliminar.', 'error');
                    }
                })
                .catch(err => {
                    Swal.fire('Error', 'Ocurrió un error al eliminar.', 'error');
                });
            }
        });
    });
});

 </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestppiscobamba.dedu.pe/resources/views/practicass/index.blade.php ENDPATH**/ ?>