<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Administrador <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Areas <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevaArea">
                    <i class="fas fa-plus"></i> Agregar Nueva Area
                </button>
                <div class="table-responsive">
                    <table id="tablaAreas" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Descripción</th>
                                <th>Estado</th>
                                <th>Fecha Creación</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($area->id); ?></td>
                                <td><?php echo e($area->nombre); ?></td>
                                <td><?php echo e(Str::limit($area->descripcion, 50)); ?></td>
                                <td>
                                    <?php if($area->estado === 'Activo'): ?>
                                        <span class="badge badge-soft-success">Activo</span>
                                    <?php else: ?>
                                        <span class="badge badge-soft-warning">Inactivo</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($area->fecha_creacion->format('d/m/Y H:i')); ?></td>
                                <td>
                                    <a href="#" 
                                        class="text-warning btnEditarArea" 
                                        title="Editar"
                                        data-id="<?php echo e($area->id); ?>"
                                        data-nombre="<?php echo e($area->nombre); ?>"
                                        data-descripcion="<?php echo e($area->descripcion); ?>"
                                        data-estado="<?php echo e($area->estado); ?>">
                                        <i class="las la-pen text-secondary font-18"></i>
                                    </a>



                                    <form action="<?php echo e(route('areas.destroy', $area->id)); ?>" method="POST" class="formEliminarArea" data-id="<?php echo e($area->id); ?>" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="button" class="btnEliminarArea" style="border:none; background:none; padding:0;">
                                            <i class="las la-trash-alt text-secondary font-18" title="Eliminar"></i>
                                        </button>
                                    </form>

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal Agregar Nueva Área -->
<!-- Modal Agregar Nueva Área -->
<div class="modal fade" id="modalNuevaArea" tabindex="-1" aria-labelledby="modalNuevaAreaLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form id="formNuevaArea">
        <?php echo csrf_field(); ?>
        <div class="modal-header">
          <h5 class="modal-title" id="modalNuevaAreaLabel">Agregar Nueva Área</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="nombre" class="form-label">Nombre</label>
            <input type="text" class="form-control" id="nombre" name="nombre" required>
          </div>
          <div class="mb-3">
            <label for="descripcion" class="form-label">Descripción</label>
            <textarea class="form-control" id="descripcion" name="descripcion" rows="3"></textarea>
          </div>
          <div class="mb-3">
            <label for="estado" class="form-label">Estado</label>
            <select class="form-select" id="estado" name="estado" required>
              <option value="Activo" selected>Activo</option>
              <option value="Inactivo">Inactivo</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary">Guardar Área</button>
        </div>
      </form>
    </div>
  </div>
</div>


<div class="modal fade" id="modalEditarArea" tabindex="-1" aria-labelledby="modalEditarAreaLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditarArea" method="POST" action="">
      <?php echo csrf_field(); ?>
      <?php echo method_field('PUT'); ?>
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalEditarAreaLabel">Editar Área</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">

          <input type="hidden" name="id" id="editAreaId">

          <div class="mb-3">
            <label for="editNombre" class="form-label">Nombre</label>
            <input type="text" class="form-control" id="editNombre" name="nombre" required>
          </div>

          <div class="mb-3">
            <label for="editDescripcion" class="form-label">Descripción</label>
            <textarea class="form-control" id="editDescripcion" name="descripcion" rows="3"></textarea>
          </div>

          <div class="mb-3">
            <label for="editEstado" class="form-label">Estado</label>
            <select class="form-select" id="editEstado" name="estado" required>
              <option value="Activo">Activo</option>
              <option value="Inactivo">Inactivo</option>
            </select>
          </div>

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Guardar Cambios</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaAreas").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaAreas_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- agregar  -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
    const formNuevaArea = document.getElementById('formNuevaArea');

    formNuevaArea.addEventListener('submit', function(e) {
        e.preventDefault();

        const formData = new FormData(formNuevaArea);
        const token = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        fetch("<?php echo e(route('areas.store')); ?>", {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': token,
            'Accept': 'application/json',
        },
        body: formData
        })
        .then(response => response.json())
        .then(data => {
        if (data.success) {
            const modal = bootstrap.Modal.getInstance(document.getElementById('modalNuevaArea'));
            modal.hide();
            formNuevaArea.reset();

            Swal.fire({
            icon: 'success',
            title: '¡Éxito!',
            text: data.message || 'Área creada correctamente',
            timer: 2000,
            showConfirmButton: false
            }).then(() => {
            location.reload(); // recarga la página para actualizar la tabla
            });

        } else {
            Swal.fire({
            icon: 'error',
            title: 'Error',
            text: data.message || 'Error al crear el área'
            });
        }
        })
        .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Ocurrió un error inesperado. Intenta de nuevo.'
        });
        });
    });
    });
</script>


<!-- editar  -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const modalEditar = new bootstrap.Modal(document.getElementById('modalEditarArea'));
        const formEditarArea = document.getElementById('formEditarArea');

        document.querySelectorAll('.btnEditarArea').forEach(btn => {
            btn.addEventListener('click', function (e) {
            e.preventDefault();

            // Leer data attributes
            const id = this.dataset.id;
            const nombre = this.dataset.nombre;
            const descripcion = this.dataset.descripcion;
            const estado = this.dataset.estado;

            // Llenar formulario
            document.getElementById('editAreaId').value = id;
            document.getElementById('editNombre').value = nombre;
            document.getElementById('editDescripcion').value = descripcion;
            document.getElementById('editEstado').value = estado;

            // Actualizar la acción del formulario (URL update)
            formEditarArea.action = `/areas/${id}`;

            // Abrir modal
            modalEditar.show();
            });
        });

        // Enviar formulario por AJAX
        formEditarArea.addEventListener('submit', function (e) {
            e.preventDefault();

            const formData = new FormData(formEditarArea);
            const token = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            fetch(formEditarArea.action, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': token,
                'Accept': 'application/json',
                'X-HTTP-Method-Override': 'PUT'
            },
            body: formData
            })
            .then(resp => resp.json())
            .then(data => {
                if (data.success) {
                modalEditar.hide();

                Swal.fire({
                    icon: 'success',
                    title: '¡Éxito!',
                    text: data.message || 'Área actualizada correctamente',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    location.reload();
                });
                } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message || 'Error al actualizar el área'
                });
                }
            })
            .catch(() => {
                Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Error inesperado, intenta de nuevo.'
                });
            });
        });
    });


</script>
<!-- eliminar  -->
 <script>
document.addEventListener('DOMContentLoaded', function () {
    const botonesEliminar = document.querySelectorAll('.btnEliminarArea');

    botonesEliminar.forEach(button => {
        button.addEventListener('click', function () {
            const form = this.closest('form');
            const areaId = form.getAttribute('data-id');
            const url = form.action;
            const token = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            Swal.fire({
                title: '¿Estás seguro?',
                text: "¡Esta acción no se puede revertir!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(url, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': token,
                            'Accept': 'application/json',
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({}),
                    })
                    .then(response => {
                        if (!response.ok) throw new Error('Error en la respuesta');
                        return response.json();
                    })
                    .then(data => {
                        if (data.success) {
                            Swal.fire(
                                'Eliminado',
                                data.message || 'Área eliminada correctamente',
                                'success'
                            );
                            // Opcional: recargar la tabla o la página
                            setTimeout(() => location.reload(), 1500);
                        } else {
                            Swal.fire('Error', data.message || 'No se pudo eliminar', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        Swal.fire('Error', 'Error al eliminar, intenta de nuevo.', 'error');
                    });
                }
            });
        });
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestppiscobamba.dedu.pe/resources/views/areas/index.blade.php ENDPATH**/ ?>