<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Periodos <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                    <form id="form-filtro" style="padding-bottom: 25px;">
                        <div class="row align-items-end">
                            <div class="col-md-2">
                                <label>Periodo</label>
                                <select name="periodo_id" class="form-control">
                                    <option value="">Todos</option>
                                    <?php $__currentLoopData = $periodos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periodo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($periodo->id); ?>"><?php echo e($periodo->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label>Plan de Estudio</label>
                                <select name="plan_estudio_id" class="form-control">
                                    <option value="">Todos</option>
                                    <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label>Semestre</label>
                                <select name="semestre_id" class="form-control">
                                    <option value="">Todos</option>
                                    <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($semestre->id); ?>"><?php echo e($semestre->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-6 d-flex gap-2 flex-wrap mt-2">
                                <button type="submit" class="btn btn-primary">Buscar</button>
                                <button type="button" id="btn-limpiar-filtros" class="btn btn-secondary">Limpiar Filtros</button>
                                <button type="button" id="btn-imprimir-reporte" class="btn btn-warning">Imprimir Reporte</button>
                                <button type="button" id="btn-acta-notas" class="btn btn-success">Acta de Notas</button>
                                <!--<button type="button" id="btn-nomina" class="btn btn-info">Nómina</button>-->
                            </div>
                        </div>
                    </form>

                    <form id="form-imprimir-reporte" action="<?php echo e(route('reporte.matriculados.pdf')); ?>" method="POST" target="_blank" style="display: none;">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="periodo_id">
                        <input type="hidden" name="plan_estudio_id">
                        <input type="hidden" name="semestre_id">
                    </form>

                   <form id="form-acta-notas" action="<?php echo e(route('reporte.acta_notas.pdf')); ?>" method="POST" target="_blank" style="display: none;">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="periodo_id">
                        <input type="hidden" name="plan_estudio_id">
                        <input type="hidden" name="semestre_id">
                    </form>
                    
                    <table id="tablamatriculados" class="table table-striped mb-0 table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Postulante</th>
                                <th>DNI</th>
                                <th>Periodo</th>
                                <th>Plan</th>
                                <th>Semestre</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Se llenará vía JS -->
                        </tbody>
                    </table>
                    

                
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>










<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    let tablaMatriculados;

    $(document).ready(function () {
        tablaMatriculados = $("#tablamatriculados").DataTable({
            responsive: true,
            lengthChange: true,
            autoWidth: false,
            buttons: [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Matriculados' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            paging: true,
            searching: true,
            info: true,
            language: {
                search: "Buscar:",
                lengthMenu: "Mostrar _MENU_ registros por página",
                info: "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                paginate: {
                    first: "Primero",
                    previous: "Anterior",
                    next: "Siguiente",
                    last: "Último"
                }
            }
        });

        tablaMatriculados.buttons().container().appendTo('#tablamatriculados_wrapper .col-md-6:eq(0)');
    });

    document.getElementById('form-filtro').addEventListener('submit', function(e) {
        e.preventDefault();

        const formData = new FormData(this);

        fetch("<?php echo e(route('reporte.matriculados.buscar')); ?>", {
            method: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            // Limpiar la tabla antes de agregar nuevas filas
            tablaMatriculados.clear();

            if (data.length === 0) {
                tablaMatriculados.draw();
                return;
            }

            const filas = data.map(matricula => {
                const nombreCompleto = `${matricula.postulante.nombres} ${matricula.postulante.apellidos}`;
                const fichaUrl = `/reporte/ficha-matricula/${matricula.id_cifrado}`;
                const boletaUrl = `/reporte/boleta/${matricula.postulante_id_cifrado}/${matricula.semestre_id_cifrado}`;

                return [
                    matricula.id, // puedes mantener el ID interno aquí si solo lo ves tú
                    nombreCompleto,
                    matricula.postulante.dni,
                    matricula.periodo.nombre,
                    matricula.plan_estudio.nombre,
                    matricula.semestre.nombre,
                    matricula.estado,
                    `
                    <a href="${fichaUrl}" target="_blank" class="btn btn-success btn-sm">
                        <i class="fas fa-certificate"></i> Ficha Matrícula
                    </a>
                    <a href="${boletaUrl}" target="_blank" class="btn btn-info btn-sm">
                        <i class="fas fa-clipboard"></i> Boleta de Notas
                    </a>
                    `
                ];
            });


            tablaMatriculados.rows.add(filas).draw();
        })
        .catch(error => {
            console.error('Error:', error);
        });
    });


    // Botón: Limpiar Filtros
    document.getElementById('btn-limpiar-filtros').addEventListener('click', function () {
        document.getElementById('form-filtro').reset();
        tablaMatriculados.clear().draw();
    });
</script>

<script>
    document.getElementById('btn-imprimir-reporte').addEventListener('click', function () {
        const filtroForm = document.getElementById('form-filtro');
        const imprimirForm = document.getElementById('form-imprimir-reporte');

        imprimirForm.periodo_id.value = filtroForm.periodo_id.value;
        imprimirForm.plan_estudio_id.value = filtroForm.plan_estudio_id.value;
        imprimirForm.semestre_id.value = filtroForm.semestre_id.value;

        imprimirForm.submit();
    });
</script>

<script>
    document.getElementById('btn-acta-notas').addEventListener('click', function () {
        const filtroForm = document.getElementById('form-filtro');
        const actaForm = document.getElementById('form-acta-notas');

        actaForm.periodo_id.value = filtroForm.periodo_id.value;
        actaForm.plan_estudio_id.value = filtroForm.plan_estudio_id.value;
        actaForm.semestre_id.value = filtroForm.semestre_id.value;

        actaForm.submit();
    });
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestppiscobamba.dedu.pe/resources/views/reportes/reporte_matriculados.blade.php ENDPATH**/ ?>